$battlePlayerImageMap = "Player_Right0ImageMap";
$PlayerHP = 100;
$PlayerPower = 10;

//enemy list
$enemyPracticeEnemy::Name = "Practice Enemy";
$enemyPracticeEnemy::MaxHP = "35";
$enemyPracticeEnemy::Power = "25";
$enemyPracticeEnemy::AttackSet = "0";
$enemyPracticeEnemy::ImageMap = "Player_Left0ImageMap";

//attack sets
$attackSet0::move0  = "enemyMoveToPlayer";
$attackSet0::move1  = "enemyAttackPosition";
$attackSet0::move1Delay = "200"; //delay before calling next move (??)
$attackSet0::move1PowerHit  = 1; //accept guards between this and next move
$attackSet0::move2  = "enemyMeleeAttack";
$attackSet0::move3  = "enemyMoveToPlayer";
$attackSet0::move3Delay = "150";
$attackSet0::move4  = "enemyStandPosition";
$attackSet0::move4Delay = "400";
$attackSet0::move5  = "endEnemyTurn";

if(!isObject(enemyGroup))
{
	new SimGroup(enemyGroup);
}

//format:
//%enemies = list of ALL enemies in the battle separated by spaces, ex: "practiceEnemy practiceBoss"
function startBattle(%enemies)
{
	if($battleInProgress)
	{
		error("tried to start battle while battle in progress!");
		return;
	}
	
	$battleInProgress = 1;
	$damageDealt = 0;
	$Player.setLinearVelocity("0 0");
	$movingUp = 0;
	$movingDown = 0;
	$movingLeft = 0;
	$movingRight = 0;
	$stopBattle = 0;
	$menuColSelected = "0";
	$menuRowSelected = "0";
	alxStopAll();
	doBattleStartTransition1(%enemies);
}

function startBattlePhase2(%enemies)
{
	//set up enemies
	$enemyCount = getWordCount(%enemies);
	
	if($enemyCount == 1)
	{
		%pos0 = $Player.getPositionX() + 25 SPC $Player.getPositionY();
	}
	if($enemyCount == 2)
	{
		%pos0 = $Player.getPositionX() + 25 SPC $Player.getPositionY() - 15;
		%pos1 = $Player.getPositionX() + 25 SPC $Player.getPositionY() + 15;
	}
	if($enemyCount == 3)
	{
		%pos0 = $Player.getPositionX() + 25 SPC $Player.getPositionY() - 30;
		%pos1 = $Player.getPositionX() + 25 SPC $Player.getPositionY();
		%pos2 = $Player.getPositionX() + 25 SPC $Player.getPositionY() + 30;
	}
	if($enemyCount > 4)
	{
		error("tried to put more than 3 enemies in one battle!");
		return;
	}
	
	%y = $Player.getPOsitionY() - 25;
	//create enemies
	for(%i = 0; %i < $enemyCount; %i++)
	{
		$enemy[%i] = new t2dStaticSprite()
		{
			scenegraph = $Player.scenegraph;
			size = "8 8";
			position = %pos[%i];
			imageMap = $enemy[getWord(%enemies, %i) @ "::ImageMap"];
			layer = 2;
			class = enemyClass;
		};
		$enemy[%i].id = getWord(%enemies, %i);
		$enemy[%i].standPos = %pos[%i];
		$enemy[%i].name = $enemy[$enemy[%i].id @ "::Name"];
		$enemy[%i].hp = $enemy[$enemy[%i].id @ "::MaxHP"];
		$enemy[%i].setBlendColour("1 1 1 0");
		enemyGroup.add($enemy[%i]);
		%y += 15;
	}
	
	//create player
	$bPlayer = new t2dStaticSprite(bPlayer)
	{
		scenegraph = $Player.scenegraph;
		size = "8 8";
		position = $Player.getPositionX() - 25 SPC $Player.getPositionY();
		imageMap = $battlePlayerImageMap;
		layer = 2;
	};
	$bPlayer.setBlendColour("1 1 1 0");
	$bPlayer.hp = $PlayerHP;
	
	//create background
	$battleBackground = new t2dStaticSprite(battleBackground)
	{
		scenegraph = $Player.scenegraph;
		size = "100 75";
		position = $Player.getPosition();
		imageMap = battleBackgroundImageMap;
		layer = 3;
	};
	$battleBackground.setBlendColour("1 1 1 0");
	
	$playerTarget = $enemy0;
	$playerTargetNum = 0;
	$targetMarker = new t2dStaticSprite(targetMarker)
	{
		scenegraph = $Player.scenegraph;
		size = "5 5";
		position = t2dVectorAdd($enemy0.getPosition(), "0 -3");
		imageMap = marker0ImageMap;
		layer = 2;
		visible = 0;
	};
	
	alxPlay(battleMusic);
	doBattleFadeIn();
}

//let you do stuff and show the target marker
function startBattlePhase3()
{
	//make the menu active
	$battleMenuActive = 1;
	setButtonStates();
	$targetMarker.setVisible(1);
}

function toggleBattleGui(%val)
{
	if(!%val)
		return;
	
	if(!battleGui.isAwake())
	{
		btnFlee.position = (-1 * getWord(btnFlee.extent, 0)) SPC getWord(btnFlee.position, 1);
		btnFight.position = (-1 * getWord(btnFight.extent, 0)) SPC getWord(btnFight.position, 1);
		btnMenu.position = (-1 * getWord(btnMenu.extent, 0)) SPC getWord(btnMenu.position, 1);
		backLine.position = (-1 * getWord(backLine.extent, 0)) SPC getWord(backLine.position, 1);
		setButtonStates();
		canvas.pushDialog(battleGui);
		setButtonStates();
		battleGuiAppear();
	}else{
		canvas.popDialog(battleGui);
	}
}

function battleGuiAppear()
{
	%inc1 = 5;
	%inc2 = 5;
	%inc3 = 5;
	%inc4 = 5;
	
	if(btnFlee.position !$= $btnFleeDefaultPos)
		btnFlee.position = getWord(btnFlee.position, 0) + %inc1 SPC getWord(btnFlee.position, 1);
	if(btnFight.position !$= $btnFightDefaultPos)
		btnFight.position = getWord(btnFight.position, 0) + %inc2 SPC getWord(btnFight.position, 1);
	if(btnMenu.position !$= $btnMenuDefaultPos)
		btnMenu.position = getWord(btnMenu.position, 0) + %inc3 SPC getWord(btnMenu.position, 1);
	if(backLine.position !$= $backLineDefaultPos)
		backLine.position = getWord(backLine.position, 0) + %inc4 SPC getWord(backLine.position, 1);
	
	if(btnFlee.position !$= $btnFleeDefaultPos || btnFight.position !$= $btnFightDefaultPos || btnMenu.position !$= $btnMenuDefaultPos || backLine.position !$= $backLineDefaultPos)
		$bGuiAppearSched = schedule(5, 0, "battleGuiAppear");
}

function playerAttack()
{
	$targetMarker.setVisible(0);
	$battleMenuActive = 0;
	resetBattleGui();
	$didPowerHit = 0;
	$powerHitSucceed = 0;
	
	$playerAttackStage0 = "playerMoveToEnemy";
	$playerAttackStage1 = "playerAttackPosition";
	$playerAttackStage1Delay = "200"; //time to wait before calling next
	$playerAttackStage1PowerHit = 1;
	$playerAttackStage2 = "playerStandardAttack";
	$playerAttackStage3 = "playerMoveToEnemy";
	$playerAttackStage3Delay = "150";
	$playerAttackStage4 = "playerStandPosition";
	$playerAttackStage4Delay = "400";
	$playerAttackStage5 = "endPlayerTurn";
	
	$playerCurAttackStage = 0;
	Call($PlayerAttackStage0);
}

function playerMoveToEnemy()
{
	$bPlayer.moveTo(t2dVectorAdd($playerTarget.getPosition(), "-6 0"), 150, 1, 1);
}

function playerAttackPosition()
{
	$bPlayer.moveTo(t2dVectorAdd($playerTarget.getPosition(), "-4 0"), 150, 1, 1);
}

function playerStandPosition()
{
	$bPlayer.moveTo($Player.getPositionX() - 25 SPC $Player.getPositionY(), 150, 1, 1);
}

function playerStandardAttack()
{
	setWaitForPowerHit(0);
	%damage = 10;
	
	if($powerHitSucceed)
	{
		sceneWindow2D.startCameraShake(25, 0.1);
		%damage *= 2;
	}
	
	playRandomHitSound();
	
	doDamage($playerTarget, %damage);
	nextAttackStage();
}

function nextAttackStage()
{
	$playerCurAttackStage++;
	if($playerAttackStage[$playerCurAttackStage @ "Delay"] > 0)
	{
		if($playerAttackStage[$playerCurAttackStage @ "PowerHit"] == 1)
		{
			setWaitForPowerHit(1, "Player");
		}
		
		schedule($playerAttackStage[$playerCurAttackStage @ "Delay"] / $difficulty, 0, $playerAttackStage[$playerCurAttackStage]);
	}else{
		Call($playerAttackStage[$playerCurAttackStage]);
	}
}

function bPlayer::onPositionTarget(%this)
{
	nextAttackStage();
}

function endPlayerTurn()
{
	if(enemiesExist())
		startEnemyTurn();
	else
		endBattle("win");
}

function startPlayerTurn()
{
	if($stopBattle)
		return;	
	
	$battleMenuActive = 1;
	setButtonStates();
	if(!enemiesExist())
	{
		endBattle("Win");
		return;
	}
	
	if(!isObject($playerTarget) || $playerTarget.killed)
		nextTarget(1, 1);
	
	$targetMarker.setVisible(1);
}

function doDamage(%obj, %damage)
{
	if(%obj == $bPlayer && %damage >= (%obj.hp / 2))
	{
		sceneWindow2D.startCameraShake(25, 0.2);
	}
	
	%obj.hp -= %damage;
	if(%obj.hp <= 0)
	{
		%obj.hp = 0;
		if(%obj != $bPlayer)
		{
			enemyKilled(%obj);
		}else{
			playerKilled();
		}
	}
	
	if(%obj == $bPlayer)
	{
		showHP();
	}else{
		$damageDealt += %damage;
	}
	
	floatingMessage(%obj.getPosition(), %damage * -1, "4 4", "-5");
}

function enemyKilled(%obj)
{
	%obj.killed = 1;
	doEnemyFadeOut(%obj);
}

function setTarget(%obj)
{
	if(!isObject(%obj))
		return;
	
	$playerTarget = %obj;
	$targetMarker.setPosition(t2dVectorAdd(%obj.getPosition(), "0 -3"));
}

function enemiesExist()
{
	for(%i = 0; %i < enemyGroup.getCount(); %i++)
	{
		if(!enemyGroup.getObject(%i).killed)
			return(1);
	}
	return(0);
}

function nextTarget(%val, %over)
{
	if(!%val || !$battleInProgress)
		return;
	if(!enemiesExist())
		return;
	if(!$targetMarker.visible && !%over)
		return;
	
	if(!%over)
		alxPlay(targetSwitchSound);
	
	$playerTargetNum++;
	if($playerTargetNum > $enemyCount)
		$playerTargetNum = 0;
	
	%target = $enemy[$playerTargetNum];
	while(!isObject(%target) || %target.killed)
	{
		$playerTargetNum++;
		if($playerTargetNum > $enemyCount)
			$playerTargetNum = 0;
		%target = $enemy[$playerTargetNum];
	}
	setTarget(%target);
}

function playerKilled()
{
	$stopBattle = 1;
	endBattle("Defeat");
}

function endBattle(%condition)
{
	if($bPlayer.hp <= 0)
		$bPlayer.hp = 1;
	$PlayerHP = $bPlayer.hp;
	if($showPowerHitIndicator)
	{
		$powerHitIndicator.setVisible(0);
	}
	
	winner.setText(strUpr(%condition));
	
	//show stats screen
	expGained.setText("000");
	dmgDealt.setText($damageDealt);
	canvas.pushDialog(battleStatsGui);
	
	//play music
	alxStopAll();
	if(%condition $= "Win")
	{
		alxPlay(victoryMusic);
	}else{
		alxPlay(defeatMusic);
	}
	
	schedule(800, 0, "allowBattleClose");
}

function allowBattleClose()
{
	$allowBattleClose = 1;
}

function doBattleClose()
{
	canvas.popDialog(battleStatsGui);
	returnFromBattle1();
}

function doEnemyFadeOut(%obj)
{
	%obj.setBlendColour("1 1 1 " @ getWord(%obj.getBlendColour(), 3) - 0.05);
	
	if(%obj.getBlendColour() !$= "1.000000 1.000000 1.000000 0.000000")
	{
		schedule(32, 0, "doEnemyFadeOut", %obj);
	}else{
		%obj.delete();
	}
}

function showHP()
{
	hpText.setText($bPlayer.hp);
}

function startEnemyTurn()
{
	for(%i = 0; %i < enemyGroup.getCount(); %i++)
	{
		%obj = enemyGroup.getObject(%i);
		if(!%obj.killed)
		{
			%list = $enemy[%obj.id @ "::AttackSet"];
			%move = getWord(%list, getRandom(0, getWordCount(%list) - 1));
			%m = 0;
			while($attackSet[%move @ "::move" @ %m] !$= "")
			{
				$enemy[%i @ "AttackStage" @ %m] = $attackSet[%move @ "::move" @ %m];
				$enemy[%i @ "AttackStage" @ %m @ "Delay"] = $attackSet[%move @ "::move" @ %m @ "Delay"];
				$enemy[%i @ "AttackStage" @ %m @ "PowerHit"] = $attackSet[%move @ "::move" @ %m @ "PowerHit"];
				%m++;
			}
		}
	}
	
	$powerHitSucceed = 0;
	$didPowerHit = 0;
	
	$enemyCurAttackStage = 0;
	$currentEnemyTurn = 0;
	Call($enemy0AttackStage0, enemyGroup.getObject($currentEnemyTurn));
}

function endEnemyTurn()
{
	$powerHitSucceed = 0;
	$didPowerHit = 0;
	
	if($stopBattle)
		return;	
	
	$currentEnemyTurn++;
	$enemyCurAttackStage = 0;
	if($currentEnemyTurn > enemyGroup.getCount() - 1)
	{
		startPlayerTurn();
		return;
	}else{
		Call($enemy[$currentEnemyTurn @ "AttackStage" @ 0], enemyGroup.getObject($currentEnemyTurn));
	}
}

function enemyMoveToPlayer(%obj)
{
	%obj.moveTo(t2dVectorAdd($bPlayer.getPosition(), "6 0"), 150, 1, 1);
}

function enemyAttackPosition(%obj)
{
	%obj.moveTo(t2dVectorAdd($bPlayer.getPosition(), "4 0"), 150, 1, 1);
}

function enemyStandPosition(%obj)
{
	%obj.moveTo(%obj.standPos, 150, 1, 1);
}

function enemyMeleeAttack(%obj)
{
	setWaitForPowerHit(0);
	%damage = 20;
	
	if($powerHitSucceed)
	{
		%damage = %damage / 2;
		alxPlay(blockSound);
	}else{
		playRandomHitSound();
	}
	
	doDamage($bPlayer, %damage);
	nextEnemyAttackStage();
}

function nextEnemyAttackStage()
{
	$enemyCurAttackStage++;
	if($enemy[$currentEnemyTurn @ "AttackStage" @ $enemyCurAttackStage @ "Delay"] > 0)
	{
		if($enemy[$currentEnemyTurn @ "AttackStage" @ $enemyCurAttackStage @ "powerHit"] == 1)
		{
			setWaitForPowerHit(1, "Enemy");
		}
		
		schedule($enemy[$currentEnemyTurn @ "AttackStage" @ $enemyCurAttackStage @ "Delay"] / $difficulty, 0, $enemy[$currentEnemyTurn @ "AttackStage" @ $enemyCurAttackStage], enemyGroup.getObject($currentEnemyTurn));
	}else{
		Call($enemy[$currentEnemyTurn @ "AttackStage" @ $enemyCurAttackStage], enemyGroup.getObject($currentEnemyTurn));
	}
}

function enemyClass::onPositionTarget(%this)
{
	nextEnemyAttackStage();
}

function playRandomHitSound()
{
	%num = getRandom(0, $hitSoundCount);
	alxPlay("hit" @ %num @ "Sound");
}

function setWaitForPowerHit(%val, %type)
{
	if(!isObject($powerHitIndicator))
		createPowerHitIndicator();
	
	if(%val)
	{
		if($showPowerHitIndicator && !$didPowerHit)
		{
			$powerHitIndicator.setPosition(t2dVectorAdd($bPlayer.getPosition(), "0 -3.25"));
			$powerHitIndicator.setVisible(1);
		}
		
		$waitingForPowerHit = 1;
	}else{
		if($showPowerHitIndicator)
			$powerHitIndicator.setVisible(0);
		
		$waitingForPowerHit = 0;
	}
}

function createPowerHitIndicator()
{
	if(isObject($powerHitIndicator))
		return;
	
	$powerHitIndicator = new t2dStaticSprite(battleBackground)
	{
		scenegraph = $Player.scenegraph;
		size = "5 5";
		position = $Player.getPosition();
		imageMap = powerHitIndicatorImageMap;
		layer = 1;
		visible = 0;
	};
}
